/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.report.Report;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.task.PresentationTask;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.task.TaskErrorIds;
import com.ibm.hwmca.fw.task.TaskLauncher;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.text.MessageFormat;
import java.util.Set;

public class TaskBean
extends PanelBean
implements TaskActionListener,
TaskErrorIds {
    private static final String TRACE_MASKT = "XFRMTBNT";
    private static final String TRACE_MASKF = "XFRMTBNF";
    private static final String TRACE_MASKD = "XFRMTBND";
    public static final String REAL_TASKLET_KEY = "REAL_TASKLET";
    public static final String LOCKED_TARGETS_KEY = "LOCKED_TARGETS";
    public static final String TASKLET_DATA_KEY = "TASKLET_DATA";
    public static final String TASKID_KEY = "TASK_ID";
    private static final String highlightTextSwing = "<html><body bgcolor=\"RED\"><font color=\"BLACK\">{0}</font></body></html>";
    private static final String highlightTextHtml = "<html><body><div style=''color: red;''>{0}</div></body></html>";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "TaskBean");
    private static final int SINGLE_OBJECT_SELECTION = 1;
    private static final int INVALID_TARGETS_PANEL = 2;
    private static final int SINGLE_CONFIRMATION_PANEL = 3;
    private static final int MULTI_CONFIRMATION_PANEL = 4;
    private static final int SECONDARY_WARNING_PANEL = 5;
    private static final int MISSING_TARGET_PANEL = 6;
    private static final int TARGET_PROMPT_PANEL = 7;
    private int panel = 0;
    private LocalizableText taskName = null;
    private Report[] targetInfo = null;
    private String[][] targetData = null;
    private LocalizableText singleConfirmText = null;
    private boolean allTargetsInvalid = false;
    private Long taskId = null;
    private PresentationTaskParms parms = null;
    private Set taskAcceptableTypes = null;
    private boolean showObjectList = true;
    private String m_sTaskSelectLabelOutput;
    private String m_sObjectSelectChoice;
    private ValueDescriptor[] m_cdObjectSelectChoice;
    private ItemDescriptor[] m_idPromptTable;
    private ColumnDescriptor[] m_cdPromptTableStructure;
    private int[] m_iPromptTableSelection;
    private String[] m_sObjectNamePCol;
    private ItemDescriptor[] m_idObjectNamePCol;
    private String[] m_sStatusCol;
    private ItemDescriptor[] m_idStatusCol;
    private String m_sTaskStatusLabelOutput;
    private String m_sTaskMessageOutput;
    private String m_sTaskConfirmationChoice;
    private ValueDescriptor[] m_cdTaskConfirmationChoice;
    private String[] m_sSecondaryObjectNamePCol;
    private ItemDescriptor[] m_idSecondaryObjectNamePCol;
    private String[] m_sOperatingStatusCol;
    private ItemDescriptor[] m_idOperatingStatusCol;
    private String m_sTaskDisrupLabelOutput;
    private String highlightText = CommonSystem.getCommonSystem().isUsingHTML() ? "<html><body><div style=''color: red;''>{0}</div></body></html>" : "<html><body bgcolor=\"RED\"><font color=\"BLACK\">{0}</font></body></html>";

    public void initTargetPromptPanel(LocalizableText taskName, Report[] targetInfo, Long taskId, PresentationTaskParms parms, Set acceptableTypes) {
        this.panel = 7;
        this.taskName = taskName;
        this.targetInfo = targetInfo;
        this.taskId = taskId;
        this.parms = parms;
        this.taskAcceptableTypes = acceptableTypes;
    }

    public ColumnDescriptor[] getPromptTableRowStructure() {
        return this.m_cdPromptTableStructure;
    }

    public int getPromptTableRowStatus() {
        return 3;
    }

    public int getPromptTableRowCount() {
        return this.m_idPromptTable.length;
    }

    public ItemDescriptor[] getPromptTableRowAt(int index) {
        ItemDescriptor[] rowAt = new ItemDescriptor[]{this.m_idPromptTable[index]};
        return rowAt;
    }

    public void setPromptTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "setting index " + index + " to " + items[0].getName() + "; " + items[0].getTitle());
        this.m_idPromptTable[index] = items[0];
    }

    public int[] getPromptTableSelection() {
        return this.m_iPromptTableSelection;
    }

    public void setPromptTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iPromptTableSelection = new int[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            this.m_iPromptTableSelection[i] = selected[i];
        }
    }

    public void initSingleObjectSelection(LocalizableText taskName, Report[] targetInfo, Long taskId, PresentationTaskParms parms, Set acceptableTypes) {
        this.panel = 1;
        this.taskName = taskName;
        this.targetInfo = targetInfo;
        this.taskId = taskId;
        this.parms = parms;
        this.taskAcceptableTypes = acceptableTypes;
    }

    public void initMissingTargetPanel(LocalizableText taskName, Report[] targetInfo, Long taskId, PresentationTaskParms parms, Set acceptableTypes) {
        this.panel = 6;
        this.taskName = taskName;
        this.targetInfo = targetInfo;
        this.taskId = taskId;
        this.parms = parms;
        this.taskAcceptableTypes = acceptableTypes;
    }

    public String getTaskSelectLabelOutput() {
        return this.m_sTaskSelectLabelOutput;
    }

    public void setTaskSelectLabelOutput(String s) {
        this.m_sTaskSelectLabelOutput = s;
    }

    public String getObjectSelectChoice() {
        return this.m_sObjectSelectChoice;
    }

    public void setObjectSelectChoice(String s) {
        this.m_sObjectSelectChoice = s;
        Trace.trace(TRACE_MASKT, "<> TaskBean.setObjectSelectChoice [" + s + "]");
    }

    public ValueDescriptor[] getObjectSelectChoiceList() {
        return this.m_cdObjectSelectChoice;
    }

    public void initInvalidTargetDisplay(LocalizableText taskName, String[][] targetData, boolean allTargetsInvalid, Long taskId, PresentationTaskParms parms, Set acceptableTypes) {
        this.panel = 2;
        this.allTargetsInvalid = allTargetsInvalid;
        this.targetData = targetData;
        this.taskName = taskName;
        this.taskId = taskId;
        this.parms = parms;
        this.taskAcceptableTypes = acceptableTypes;
    }

    public String getTaskStatusLabelOutput() {
        return this.m_sTaskStatusLabelOutput;
    }

    public void setTaskStatusLabelOutput(String s) {
        this.m_sTaskStatusLabelOutput = s;
    }

    public ItemDescriptor[] getObjectNamePColList() {
        return this.m_idObjectNamePCol;
    }

    public void setObjectNamePColList(ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idObjectNamePCol = items;
    }

    public String[] getObjectNamePColSelection() {
        return this.m_sObjectNamePCol;
    }

    public void setObjectNamePColSelection(String[] select) throws IllegalUserDataException {
        this.m_sObjectNamePCol = select;
    }

    public ItemDescriptor[] getStatusColList() {
        return this.m_idStatusCol;
    }

    public void setStatusColList(ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idStatusCol = items;
    }

    public String[] getStatusColSelection() {
        return this.m_sStatusCol;
    }

    public void setStatusColSelection(String[] select) throws IllegalUserDataException {
        this.m_sStatusCol = select;
    }

    public void initConfirmationPanel(LocalizableText taskName, String[][] targetData, LocalizableText singleConfirmText, Long taskId, PresentationTaskParms parms, Set acceptableTypes, boolean showObjectList) {
        this.panel = singleConfirmText != null ? 3 : 4;
        this.taskName = taskName;
        this.targetData = targetData;
        this.singleConfirmText = singleConfirmText;
        this.taskId = taskId;
        this.parms = parms;
        this.taskAcceptableTypes = acceptableTypes;
        this.showObjectList = showObjectList;
    }

    public String getTaskMessageOutput() {
        return this.m_sTaskMessageOutput;
    }

    public void setTaskMessageOutput(String s) {
        this.m_sTaskMessageOutput = s;
    }

    public String getTaskConfirmationChoice() {
        return this.m_sTaskConfirmationChoice;
    }

    public void setTaskConfirmationChoice(String s) {
        this.m_sTaskConfirmationChoice = s;
    }

    public ValueDescriptor[] getTaskConfirmationChoiceList() {
        return this.m_cdTaskConfirmationChoice;
    }

    public void initSecondaryTargetDisplay(LocalizableText taskName, String[][] targetData, Long taskId, PresentationTaskParms parms, Set acceptableTypes) {
        this.panel = 5;
        this.targetData = targetData;
        this.taskName = taskName;
        this.taskId = taskId;
        this.parms = parms;
        this.taskAcceptableTypes = acceptableTypes;
    }

    public String getTaskDisrupLabelOutput() {
        return this.m_sTaskDisrupLabelOutput;
    }

    public void setTaskDisrupLabelOutput(String s) {
        this.m_sTaskDisrupLabelOutput = s;
    }

    public ItemDescriptor[] getSecondaryObjectNamePColList() {
        return this.m_idSecondaryObjectNamePCol;
    }

    public void setSecondaryObjectNamePColList(ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idSecondaryObjectNamePCol = items;
    }

    public String[] getSecondaryObjectNamePColSelection() {
        return this.m_sSecondaryObjectNamePCol;
    }

    public void setSecondaryObjectNamePColSelection(String[] select) throws IllegalUserDataException {
        this.m_sSecondaryObjectNamePCol = select;
    }

    public ItemDescriptor[] getOperatingStatusColList() {
        return this.m_idOperatingStatusCol;
    }

    public void setOperatingStatusColList(ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idOperatingStatusCol = items;
    }

    public String[] getOperatingStatusColSelection() {
        return this.m_sOperatingStatusCol;
    }

    public void setOperatingStatusColSelection(String[] select) throws IllegalUserDataException {
        this.m_sOperatingStatusCol = select;
    }

    public void verifyChanges() {
    }

    public void save() {
    }

    public void setParms(PresentationTaskParms parms) {
        this.parms = parms;
    }

    public void load() {
        switch (this.panel) {
            case 1: 
            case 6: {
                this.m_sTaskSelectLabelOutput = this.taskName.toString().replace('\n', ' ');
                this.m_cdObjectSelectChoice = new ValueDescriptor[this.targetInfo.length];
                for (int i = 0; i < this.targetInfo.length; ++i) {
                    this.m_cdObjectSelectChoice[i] = new ValueDescriptor(this.targetInfo[i].getObjectId().toString(), this.targetInfo[i].getText().toString().replace('\n', ' '));
                    if (i != 0) continue;
                    this.m_sObjectSelectChoice = this.m_cdObjectSelectChoice[i].getTitle();
                }
                break;
            }
            case 2: {
                this.m_sTaskStatusLabelOutput = this.taskName.toString().replace('\n', ' ');
                this.m_sObjectNamePCol = new String[0];
                this.m_sStatusCol = new String[0];
                this.m_idObjectNamePCol = new ItemDescriptor[this.targetData.length];
                this.m_idStatusCol = new ItemDescriptor[this.targetData.length];
                BaseMessageTitle validText = new BaseMessageTitle("task.target.valid");
                for (int i = 0; i < this.targetData.length; ++i) {
                    if (this.targetData[i][1] != null) {
                        Object[] subst = new Object[]{this.targetData[i][0].toString().replace('\n', ' ')};
                        this.m_idObjectNamePCol[i] = new ItemDescriptor("OBJECT_" + i, MessageFormat.format(this.highlightText, subst));
                        subst = new Object[]{this.targetData[i][1].toString()};
                        this.m_idStatusCol[i] = new ItemDescriptor("STATUS_" + i, MessageFormat.format(this.highlightText, subst));
                        continue;
                    }
                    this.m_idObjectNamePCol[i] = new ItemDescriptor("OBJECT_" + i, this.targetData[i][0].toString().replace('\n', ' '));
                    this.m_idStatusCol[i] = new ItemDescriptor("STATUS_" + i, validText.toString());
                }
                break;
            }
            case 4: {
                this.m_sObjectNamePCol = new String[0];
                this.m_sStatusCol = new String[0];
                this.m_idObjectNamePCol = new ItemDescriptor[this.targetData.length];
                this.m_idStatusCol = new ItemDescriptor[this.targetData.length];
                for (int i = 0; i < this.targetData.length; ++i) {
                    this.m_idObjectNamePCol[i] = new ItemDescriptor("OBJECT_" + i, this.targetData[i][0].toString().replace('\n', ' '));
                    this.m_idStatusCol[i] = new ItemDescriptor("STATUS_" + i, this.targetData[i][1].toString());
                }
                break;
            }
            case 3: {
                this.m_sTaskMessageOutput = this.singleConfirmText.toString();
                this.m_sTaskConfirmationChoice = "";
                this.m_cdTaskConfirmationChoice = new ValueDescriptor[this.targetData.length];
                for (int i = 0; i < this.targetData.length; ++i) {
                    this.m_cdTaskConfirmationChoice[i] = new ValueDescriptor("OBJECT_" + i, this.targetData[i][0].toString().replace('\n', ' '));
                }
                break;
            }
            case 5: {
                this.m_sTaskDisrupLabelOutput = this.taskName.toString().replace('\n', ' ');
                this.m_sSecondaryObjectNamePCol = new String[0];
                this.m_sOperatingStatusCol = new String[0];
                this.m_idSecondaryObjectNamePCol = new ItemDescriptor[this.targetData.length];
                this.m_idOperatingStatusCol = new ItemDescriptor[this.targetData.length];
                for (int i = 0; i < this.targetData.length; ++i) {
                    this.m_idSecondaryObjectNamePCol[i] = new ItemDescriptor("OBJECT_" + i, this.targetData[i][0].toString().replace('\n', ' '));
                    this.m_idOperatingStatusCol[i] = new ItemDescriptor("STATUS_" + i, this.targetData[i][1].toString().replace('\n', ' '));
                }
                break;
            }
            case 7: {
                this.m_sTaskSelectLabelOutput = this.taskName.toString().replace('\n', ' ');
                this.m_idPromptTable = new ItemDescriptor[this.targetInfo.length];
                this.m_cdPromptTableStructure = new ColumnDescriptor[0];
                this.m_iPromptTableSelection = new int[0];
                ItemDescriptor[] row = new ItemDescriptor[1];
                for (int i = 0; i < this.targetInfo.length; ++i) {
                    row[0] = new ItemDescriptor(this.targetInfo[i].getObjectId().toString(), this.targetInfo[i].getText().toString().replace('\n', ' '));
                    this.setPromptTableRowAt(i, row);
                }
                break;
            }
        }
    }

    public void prepare() {
        switch (this.panel) {
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                if (!this.allTargetsInvalid) break;
                this.userTaskManager.setEnabled("YesButton", false);
                break;
            }
            case 4: {
                Object[] subst = new Object[]{this.taskName.toString().replace('\n', ' ')};
                String title = this.userTaskManager.getCaptionText("TaskMultiConfirmationPanel");
                title = MessageFormat.format(title, subst);
                this.userTaskManager.setCaptionText("TaskMultiConfirmationPanel", title);
                break;
            }
            case 3: {
                Object[] subst = new Object[]{this.taskName.toString().replace('\n', ' ')};
                String title = this.userTaskManager.getCaptionText("TaskConfirmationPanel");
                title = MessageFormat.format(title, subst);
                this.userTaskManager.setCaptionText("TaskConfirmationPanel", title);
                this.userTaskManager.setCaptionText("TaskMessageOutput", this.m_sTaskMessageOutput);
                if (this.showObjectList) break;
                this.userTaskManager.setShown("TaskConfirmationChoice", false);
                this.userTaskManager.setShown("ObjectConfirmationLabel", false);
                break;
            }
            case 5: {
                break;
            }
            case 7: {
                if (this.targetInfo != null && this.targetInfo.length != 0) break;
                this.userTaskManager.setEnabled("OKButton", false);
            }
        }
    }

    public void panelAction(TaskActionEvent evt) {
        try {
            String command = evt.getActionCommand();
            Trace.trace(TRACE_MASKT, "-> TaskBean for command: [" + command + "]; panel: [" + this.panel + "].");
            UserTaskManager utm = (UserTaskManager)evt.getSource();
            switch (this.panel) {
                case 1: {
                    if (command.equals("CANCEL")) {
                        PanelTaskletRequest request = new PanelTaskletRequest();
                        this.postTaskletRequest(request);
                        break;
                    }
                    if (!command.equals("OKButton")) break;
                    utm.storeAllElements();
                    ObjectId id = null;
                    for (int i = 0; this.m_sObjectSelectChoice != null && i < this.m_cdObjectSelectChoice.length && id == null; ++i) {
                        if (!this.m_sObjectSelectChoice.equals(this.m_cdObjectSelectChoice[i].getTitle())) continue;
                        PanelTaskletRequest request = new PanelTaskletRequest();
                        id = this.targetInfo[i].getObjectId();
                        Trace.trace(TRACE_MASKF, "select choice is: [" + id + "]");
                        request.setData(TASKLET_DATA_KEY, id);
                        this.postTaskletRequest(request);
                        if (this.taskId == null || this.parms == null) continue;
                        Trace.trace(TRACE_MASKF, "looking for the task...");
                        PresentationTask task = TaskLauncher.getActiveTask(this.taskId);
                        if (task == null) continue;
                        Trace.trace(TRACE_MASKF, "found the task; resetting the targets");
                        task.getParms().setTargetIds(new ObjectId[]{id});
                        task.getParms().trimTargetIds(this.taskAcceptableTypes);
                    }
                    if (id != null) break;
                    try {
                        BaseMessageTitle title = new BaseMessageTitle("task.singleselection.title");
                        BaseMessageText msg = new BaseMessageText("TSK0002");
                        CommonMsgApp.showMessageBox(utm, title, msg);
                    }
                    catch (Exception ex) {
                        new FrameworkLog(classLogInfo, 57, ex).log();
                    }
                    break;
                }
                case 2: {
                    if (command.equals("CANCEL") || command.equals("NoButton")) {
                        Boolean keepGoing = new Boolean(false);
                        PanelTaskletRequest request = new PanelTaskletRequest();
                        request.setData(TASKLET_DATA_KEY, keepGoing);
                        this.postTaskletRequest(request);
                        break;
                    }
                    if (!command.equals("YesButton")) break;
                    Boolean keepGoing = new Boolean(true);
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setData(TASKLET_DATA_KEY, keepGoing);
                    this.postTaskletRequest(request);
                    if (this.taskId == null || this.parms == null) break;
                    Trace.trace(TRACE_MASKF, "looking for the task...");
                    PresentationTask task = TaskLauncher.getActiveTask(this.taskId);
                    if (task == null) break;
                    Trace.trace(TRACE_MASKF, "found the task; resetting the targets");
                    task.getParms().setTargetIds(this.parms.getTargetIds());
                    task.getParms().trimTargetIds(this.taskAcceptableTypes);
                    break;
                }
                case 3: {
                    if (command.equals("CANCEL") || command.equals("NoButton")) {
                        Boolean keepGoing = new Boolean(false);
                        PanelTaskletRequest request = new PanelTaskletRequest();
                        request.setData(TASKLET_DATA_KEY, keepGoing);
                        this.postTaskletRequest(request);
                        break;
                    }
                    if (!command.equals("YesButton")) break;
                    Boolean keepGoing = new Boolean(true);
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setData(TASKLET_DATA_KEY, keepGoing);
                    this.postTaskletRequest(request);
                    break;
                }
                case 4: {
                    if (command.equals("CANCEL") || command.equals("NoButton")) {
                        Boolean keepGoing = new Boolean(false);
                        PanelTaskletRequest request = new PanelTaskletRequest();
                        request.setData(TASKLET_DATA_KEY, keepGoing);
                        this.postTaskletRequest(request);
                        break;
                    }
                    if (!command.equals("YesButton")) break;
                    Boolean keepGoing = new Boolean(true);
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setData(TASKLET_DATA_KEY, keepGoing);
                    this.postTaskletRequest(request);
                    break;
                }
                case 5: {
                    if (command.equals("CANCEL") || command.equals("NoButton")) {
                        Boolean keepGoing = new Boolean(false);
                        PanelTaskletRequest request = new PanelTaskletRequest();
                        request.setData(TASKLET_DATA_KEY, keepGoing);
                        this.postTaskletRequest(request);
                        break;
                    }
                    if (!command.equals("YesButton")) break;
                    Boolean keepGoing = new Boolean(true);
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setData(TASKLET_DATA_KEY, keepGoing);
                    this.postTaskletRequest(request);
                    break;
                }
                case 6: {
                    if (command.equals("CANCEL") || command.equals("NoButton")) {
                        Boolean keepGoing = new Boolean(false);
                        PanelTaskletRequest request = new PanelTaskletRequest();
                        request.setData(TASKLET_DATA_KEY, keepGoing);
                        this.postTaskletRequest(request);
                        break;
                    }
                    if (!command.equals("YesButton")) break;
                    Boolean keepGoing = new Boolean(true);
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setData(TASKLET_DATA_KEY, keepGoing);
                    this.postTaskletRequest(request);
                    if (this.taskId == null || this.parms == null) break;
                    Trace.trace(TRACE_MASKF, "looking for the task...");
                    PresentationTask task = TaskLauncher.getActiveTask(this.taskId);
                    if (task == null) break;
                    Trace.trace(TRACE_MASKF, "found the task; resetting the targets");
                    task.getParms().setTargetIds(this.parms.getTargetIds());
                    task.getParms().trimTargetIds(this.taskAcceptableTypes);
                    break;
                }
                case 7: {
                    if (command.equals("CANCEL") || command.equals("CancelButton")) {
                        PanelTaskletRequest request = new PanelTaskletRequest();
                        request.setData(TASKLET_DATA_KEY, null);
                        this.postTaskletRequest(request);
                        break;
                    }
                    if (!command.equals("OKButton")) break;
                    utm.storeAllElements();
                    int[] selRows = this.getPromptTableSelection();
                    ObjectId[] selIds = new ObjectId[selRows.length];
                    for (int i = 0; i < selRows.length; ++i) {
                        selIds[i] = this.targetInfo[selRows[i]].getObjectId();
                        Trace.trace(TRACE_MASKF, "selected target " + i + " is: " + selIds[i]);
                    }
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setData(TASKLET_DATA_KEY, selIds);
                    this.postTaskletRequest(request);
                    if (this.taskId == null || this.parms == null) break;
                    Trace.trace(TRACE_MASKF, "looking for the task...");
                    PresentationTask task = TaskLauncher.getActiveTask(this.taskId);
                    if (task == null) break;
                    Trace.trace(TRACE_MASKF, "found the task; resetting the targets");
                    task.getParms().setTargetIds(selIds);
                    task.getParms().trimTargetIds(this.taskAcceptableTypes);
                }
            }
            Trace.trace(TRACE_MASKT, "<- TaskBean for command: [" + command + "].");
        }
        catch (Exception ex) {
            Trace.trace(TRACE_MASKT, "TaskBean.panelAction exception: " + ex);
            new FrameworkLog(classLogInfo, 58, ex).log();
        }
    }
}

